﻿namespace Code6587EN.Ch01.ChangeSiteMasterPages
{
    using System;
    using Microsoft.SharePoint;

    /// <summary>
    /// Console Application to set the Site Master Pages
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the SharePoint Site Collection containing the SharePoint Site in a Using statement
            using (var site = new SPSite("http://sharepoint/site"))
            {
                // Open the SharePoint Site in a Using statement
                using (var web = site.OpenWeb())
                {
                    // Set the System Master Page
                    web.MasterUrl = "/_catalogs/masterpages/seattle.master";

                    // Set the Site Master Page
                    web.CustomMasterUrl = "/_catalogs/masterpages/seattle.master";

                    // Update the SharePoint Site
                    web.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
